#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef BUILD_RL_PRODUCT
#include <string>

#include "dllexport.h"
using namespace std;

typedef enum
{
	ALARM_Signal          = 0,
	ALARM_HDFull          = 1,
	ALARM_VideoLoss       = 2,
	ALARM_MotionDetection = 3,
	ALARM_HDUnformatted	  = 4,
	ALARM_HDAccessFailed  = 5,
	ALARM_Mask            = 6,
	ALARM_UnMatch         = 7,
	ALARM_AccessDenied    = 8,
	ALARM_VdieoException  = 9,
	ALARM_Unknown         = 10
};

typedef struct
{
	LONG     lUserID;
	LONG     AlarmType;
	DWORD    dwAlarmInputNumber;
	DWORD    dwLength;
	BYTE     byData[128];
	char     sDeviceName[128];
	char     sDeviceIP[128];
} MsgAlarmInfo;



typedef void (CALLBACK* fExceptionCallBack)(DWORD dwType, LONG lUserID, LONG lHandle, void *pUser);
typedef void (CALLBACK* HandleMessage)(MsgAlarmInfo *pMsg);
typedef void *(*GetMsgBufferCallBack)();


class DLLAPI CRLGlobal 
{
public:
    CRLGlobal();
    ~CRLGlobal();
    static BOOL Startup();
    static BOOL Cleanup();
    static BOOL StartListen(char *sLocalIP, WORD wLocalPort, void *pUserData);
    static BOOL StopListen();
    static BOOL EnableLog2File(BOOL bLogEnable, char *strLogDir, BOOL bAutoDel);
    static void RegisterAlarmCallback(void* alarmCallBack, void* userParams);
    static BOOL RegisterExceptionCallBack();
	static BOOL IsMessageCallbackRegistered();
	static void RegisterHandleMessage(void *p);
    static void RegisterHandleException(void *p);
	static void RegisterAllocator(void *p);
	static void HandleMsg(MsgAlarmInfo *pMsg);
    static void HandleException(DWORD dwType, LONG lUserID, LONG lHandle, void *pUser);
	static MsgAlarmInfo *GetBuffer();
private:
    static LONG m_lListenHandle;
	static HandleMessage m_cbHandleMsg;
    static fExceptionCallBack m_cbException;
	static GetMsgBufferCallBack m_GetMsgBuffer;
};

#endif